package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.constantes.Secuencias;
import com.ejie.ab04b.model.DatosEnvioPostal;
import com.ejie.ab04b.model.DocumentoOS2;
import com.ejie.ab04b.model.TareaOS2;
import com.ejie.ab04b.model.TipoDocumento;
import com.ejie.ab04b.model.TramiteOS2;
import com.ejie.ab04b.util.DaoUtils;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0494s00DaoImpl generated by UDA, 05-Apr-2017 09:34:34.
 * 
 * @author UDA
 */

@Repository()
@Transactional()
public class DocumentoOS2DaoImpl implements DocumentoOS2Dao {

	private final static String QUERY_SELECT = "SELECT t1.ID_DOCUMENTO_094 IDDOCUMENTO094, t1.ORIGEN_094 ORIGEN094, t1.FECHA_DOC_094 FECHADOC094, t1.RUTA_PIF_094 RUTAPIF094, t1.NOMBRE_DOC_094 NOMBREDOC094, t1.OID_DOKUSI_094 OIDDOKUSI094, t1.ID_TIPO_DOC_094 IDTIPODOC094, t1.ID_DATOS_ENVIO_POSTAL_094 IDDATOSENVIOPOSTAL094, t1.FORMATO_APORT_094 FORMATOAPORT094, t1.ID_TAREA_CONT_094 IDTAREACONT094, t1.ID_TRAMITE_OS2_094 IDTRAMITE094 FROM AB0494S00 t1 ";

	private JdbcTemplate jdbcTemplate;

	/**
	 * Gets the jdbc template.
	 * 
	 *  JdbcTemplate
	 *
	 * @return the jdbc template
	 */
	public JdbcTemplate getJdbcTemplate() {
		return this.jdbcTemplate;
	}

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<DocumentoOS2> rwMap = new RowMapper<DocumentoOS2>() {
		public DocumentoOS2 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			DocumentoOS2 documento = new DocumentoOS2(
					resultSet.getLong("IDDOCUMENTO094"),
					resultSet.getInt("ORIGEN094"),
					resultSet.getDate("FECHADOC094"),
					resultSet.getString("RUTAPIF094"),
					resultSet.getString("NOMBREDOC094"),
					resultSet.getString("OIDDOKUSI094"),
					new TipoDocumento(resultSet.getLong("IDTIPODOC094")), null,
					resultSet.getString("FORMATOAPORT094"), null,
					new TramiteOS2(resultSet.getLong("IDTRAMITE094")));

			Long idTareaContinuar = DaoUtils.getInstance()
					.getLongNullable(resultSet, "IDTAREACONT094");
			if (idTareaContinuar != null) {
				documento.setTareaOS2Continuar(new TareaOS2(idTareaContinuar));
			}

			Long idDatosEnvioPostal = DaoUtils.getInstance()
					.getLongNullable(resultSet, "IDDATOSENVIOPOSTAL094");
			if (idTareaContinuar != null) {
				documento.setDatosEnvioPostal(
						new DatosEnvioPostal(idDatosEnvioPostal));
			}

			return documento;
		}
	};

	private RowMapper<DocumentoOS2> rwMapPK = new RowMapper<DocumentoOS2>() {
		public DocumentoOS2 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new DocumentoOS2(resultSet.getLong("IDDOCUMENTO094"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 *  dataSource            DataSource
	 *
	 * @param dataSource the new data source
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Ab0494s00 table.
	 * 
	 *  ab0494s00
	 *            Ab0494s00
	 *  Ab0494s00
	 *
	 * @param ab0494s00 the ab 0494 s 00
	 * @return the documento OS 2
	 */
	public DocumentoOS2 add(DocumentoOS2 ab0494s00) {
		String query = "INSERT INTO AB0494S00 (ID_DOCUMENTO_094, ID_TAREA_CONT_094, ID_TRAMITE_OS2_094, ORIGEN_094, FECHA_DOC_094, RUTA_PIF_094, NOMBRE_DOC_094, OID_DOKUSI_094, ID_TIPO_DOC_094, ID_DATOS_ENVIO_POSTAL_094, FORMATO_APORT_094) VALUES (?,?,?,?,?,?,?,?,?,?,?)";

		// Obtenemos la secuencia
		ab0494s00.setIdDocumento094(
				Secuencias.DOC_OS2.getNextLong(jdbcTemplate));

		Long idTareaCont = null;
		if (ab0494s00.getTareaOS2Continuar() != null) {
			idTareaCont = ab0494s00.getTareaOS2Continuar().getIdTarea093();
		}

		Long idDatosEnvioPostal = null;
		if (ab0494s00.getDatosEnvioPostal() != null) {
			idTareaCont = ab0494s00.getDatosEnvioPostal()
					.getIdDatosEnvioPostal069();
		}
		Long idTipoDoc = null;
		if (ab0494s00.getTipoDocumento() != null) {
			idTipoDoc = ab0494s00.getTipoDocumento().getIdTipoDoc091();
		}
		this.jdbcTemplate.update(query, ab0494s00.getIdDocumento094(),
				idTareaCont, ab0494s00.getTramiteOS2().getIdTramite092(),
				ab0494s00.getOrigen094(), ab0494s00.getFechaDoc094(),
				ab0494s00.getRutaPif094(), ab0494s00.getNombreDoc094(),
				ab0494s00.getOidDokusi094(), idTipoDoc, idDatosEnvioPostal,
				ab0494s00.getFormatoAport094());
		return ab0494s00;
	}

	/**
	 * Updates a single row in the Ab0494s00 table.
	 * 
	 *  ab0494s00
	 *            Ab0494s00
	 *  Ab0494s00
	 *
	 * @param ab0494s00 the ab 0494 s 00
	 * @return the documento OS 2
	 */
	public DocumentoOS2 update(DocumentoOS2 ab0494s00) {
		String query = "UPDATE AB0494S00 SET ID_TAREA_CONT_094=?, ID_TRAMITE_OS2_094=?, ORIGEN_094=?, FECHA_DOC_094=?, RUTA_PIF_094=?, NOMBRE_DOC_094=?, OID_DOKUSI_094=?, ID_TIPO_DOC_094=?, ID_DATOS_ENVIO_POSTAL_094=?, FORMATO_APORT_094=? WHERE ID_DOCUMENTO_094=?";

		Long idTareaCont = null;
		if (ab0494s00.getTareaOS2Continuar() != null) {
			idTareaCont = ab0494s00.getTareaOS2Continuar().getIdTarea093();
		}

		Long idDatosEnvioPostal = null;
		if (ab0494s00.getDatosEnvioPostal() != null) {
			idTareaCont = ab0494s00.getDatosEnvioPostal()
					.getIdDatosEnvioPostal069();
		}

		this.jdbcTemplate.update(query, idTareaCont,
				ab0494s00.getTramiteOS2().getIdTramite092(),
				ab0494s00.getOrigen094(), ab0494s00.getFechaDoc094(),
				ab0494s00.getRutaPif094(), ab0494s00.getNombreDoc094(),
				ab0494s00.getOidDokusi094(),
				ab0494s00.getTipoDocumento().getIdTipoDoc091(),
				idDatosEnvioPostal, ab0494s00.getFormatoAport094(),
				ab0494s00.getIdDocumento094());
		return ab0494s00;
	}

	/**
	 * Finds a single row in the Ab0494s00 table.
	 * 
	 *  ab0494s00
	 *            Ab0494s00
	 *  Ab0494s00
	 *
	 * @param ab0494s00 the ab 0494 s 00
	 * @return the documento OS 2
	 */
	@Transactional(readOnly = true)
	public DocumentoOS2 find(DocumentoOS2 ab0494s00) {
		StringBuilder query = new StringBuilder(
				DocumentoOS2DaoImpl.QUERY_SELECT);
		query.append(" WHERE t1.ID_DOCUMENTO_094 = ? ");

		List<DocumentoOS2> ab0494s00List = this.jdbcTemplate.query(
				query.toString(), this.rwMap, ab0494s00.getIdDocumento094());
		return (DocumentoOS2) DataAccessUtils.uniqueResult(ab0494s00List);
	}

	/**
	 * Finds a single row in the Ab0494s00 table.
	 * 
	 *  oid
	 *            String
	 *  DocumentoOS2
	 *
	 * @param oid the oid
	 * @return the documento OS 2
	 */
	@Transactional(readOnly = true)
	public DocumentoOS2 findByOid(String oid) {
		StringBuilder query = new StringBuilder(
				DocumentoOS2DaoImpl.QUERY_SELECT);
		query.append(" WHERE t1.OID_DOKUSI_094 = ? ");

		List<DocumentoOS2> ab0494s00List = this.jdbcTemplate
				.query(query.toString(), this.rwMap, oid);
		return (DocumentoOS2) DataAccessUtils.uniqueResult(ab0494s00List);
	}

	/**
	 * Removes a single row in the Ab0494s00 table.
	 * 
	 *  ab0494s00            Ab0494s00
	 *
	 * @param ab0494s00 the ab 0494 s 00
	 */
	public void remove(DocumentoOS2 ab0494s00) {
		String query = "DELETE FROM AB0494S00 WHERE ID_DOCUMENTO_094=?";
		this.jdbcTemplate.update(query, ab0494s00.getIdDocumento094());
	}

	/**
	 * Finds a list of rows in the Ab0494s00 table.
	 * 
	 *  ab0494s00
	 *            Ab0494s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab0494s00>
	 *
	 * @param ab0494s00 the ab 0494 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<DocumentoOS2> findAll(DocumentoOS2 ab0494s00,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				DocumentoOS2DaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0494s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<DocumentoOS2>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Ab0494s00 table using like.
	 * 
	 *  ab0494s00
	 *            Ab0494s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Ab0494s00>
	 *
	 * @param ab0494s00 the ab 0494 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<DocumentoOS2> findAllLike(DocumentoOS2 ab0494s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				DocumentoOS2DaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0494s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<DocumentoOS2>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Ab0494s00 table.
	 * 
	 *  ab0494s00
	 *            Ab0494s00
	 *  Long
	 *
	 * @param ab0494s00 the ab 0494 s 00
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(DocumentoOS2 ab0494s00) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0494S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0494s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Ab0494s00 table using like.
	 * 
	 *  ab0494s00
	 *            Ab0494s00
	 *  startsWith
	 *            Boolean
	 *  Long
	 *
	 * @param ab0494s00 the ab 0494 s 00
	 * @param startsWith the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(DocumentoOS2 ab0494s00, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0494S00 t1");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0494s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Ab0494s00 selected for rup_table.
	 * 
	 *  ab0494s00            Ab0494s00
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<Ab0494s00>>
	 *
	 * @param ab0494s00 the ab 0494 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override()
	public List<TableRowDto<DocumentoOS2>> reorderSelection(
			DocumentoOS2 ab0494s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				DocumentoOS2DaoImpl.QUERY_SELECT);
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0494s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings(value = "unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, DocumentoOS2.class, filterParamList,
				"ID_DOCUMENTO_094");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<DocumentoOS2>(this.rwMapPK,
						jqGridRequestDto),
				filterParamList.toArray());
	}

	/**
	 * Search method for rup_table.
	 * 
	 *  filterParams            Ab0494s00
	 *  searchParams            Ab0494s00
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<Ab0494s00>>
	 *
	 * @param filterParams the filter params
	 * @param searchParams the search params
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override()
	public List<TableRowDto<DocumentoOS2>> search(DocumentoOS2 filterParams,
			DocumentoOS2 searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				DocumentoOS2DaoImpl.QUERY_SELECT);
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings(value = "unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams,
				startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings(value = "unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, DocumentoOS2.class, filterParamList,
				searchSQL, searchParamList, from_alias, "ID_DOCUMENTO_094");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<DocumentoOS2>(this.rwMapPK,
						jqGridRequestDto),
				filterParamList.toArray());
	}

	/**
	 * Updates a single row in the Expedientes table.
	 * 
	 *  ab0494s00
	 *            DocumentoOS2
	 *  DocumentoOS2
	 *
	 * @param ab0494s00 the ab 0494 s 00
	 * @return the documento OS 2
	 */
	public DocumentoOS2 updateFilled(DocumentoOS2 ab0494s00) {
		StringBuilder query = new StringBuilder("UPDATE AB0494S00 SET ");

		List<Object> params = new ArrayList<Object>();
		StringBuilder queryFields = new StringBuilder();

		if (ab0494s00 != null) {

			if (ab0494s00.getTareaOS2Continuar() != null && ab0494s00
					.getTareaOS2Continuar().getIdTarea093() != null) {
				queryFields.append(", ID_TAREA_CONT_094 = ? ");
				params.add(ab0494s00.getTareaOS2Continuar().getIdTarea093());
			}
			if (ab0494s00.getNombreDoc094() != null) {
				queryFields.append(", NOMBRE_DOC_094 = ? ");
				params.add(ab0494s00.getNombreDoc094());
			}
			if (ab0494s00.getOidDokusi094() != null) {
				queryFields.append(", OID_DOKUSI_094 = ? ");
				params.add(ab0494s00.getOidDokusi094());
			}
			if (ab0494s00.getDatosEnvioPostal() != null && ab0494s00
					.getDatosEnvioPostal().getIdDatosEnvioPostal069() != null) {
				queryFields.append(", ID_DATOS_ENVIO_POSTAL_094 = ? ");
				params.add(ab0494s00.getDatosEnvioPostal()
						.getIdDatosEnvioPostal069());
			}

			if (queryFields.length() > 0) {
				queryFields.deleteCharAt(0);
			}
		}

		query.append(queryFields);
		query.append(" WHERE ID_DOCUMENTO_094 = ?");

		params.add(ab0494s00.getIdDocumento094());

		this.jdbcTemplate.update(query.toString(), params.toArray());
		return ab0494s00;
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0494s00 entity.
	 * 
	 *  ab0494s00            Ab0494s00 Bean with the criteria values to filter by.
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param ab0494s00 the ab 0494 s 00
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(DocumentoOS2 ab0494s00) {

		StringBuilder where = new StringBuilder(
				DocumentoOS2DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0494s00 != null && ab0494s00.getIdDocumento094() != null) {
			where.append(" AND t1.ID_DOCUMENTO_094 = ?");
			params.add(ab0494s00.getIdDocumento094());
		}
		if (ab0494s00 != null && ab0494s00.getTareaOS2Continuar() != null
				&& ab0494s00.getTareaOS2Continuar().getIdTarea093() != null) {
			where.append(" AND t1.ID_TAREA_CONT_094 = ?");
			params.add(ab0494s00.getTareaOS2Continuar().getIdTarea093());
		}
		if (ab0494s00 != null && ab0494s00.getTramiteOS2() != null
				&& ab0494s00.getTramiteOS2().getIdTramite092() != null) {
			where.append(" AND t1.ID_TRAMITE_OS2_094 = ?");
			params.add(ab0494s00.getTramiteOS2().getIdTramite092());
		}
		if (ab0494s00 != null && ab0494s00.getOrigen094() != null) {
			where.append(" AND t1.ORIGEN_094 = ?");
			params.add(ab0494s00.getOrigen094());
		}
		if (ab0494s00 != null && ab0494s00.getFechaDoc094() != null) {
			where.append(" AND t1.FECHA_DOC_094 = ?");
			params.add(ab0494s00.getFechaDoc094());
		}
		if (ab0494s00 != null && ab0494s00.getRutaPif094() != null) {
			where.append(" AND t1.RUTA_PIF_094 = ?");
			params.add(ab0494s00.getRutaPif094());
		}
		if (ab0494s00 != null && ab0494s00.getNombreDoc094() != null) {
			where.append(" AND t1.NOMBRE_DOC_094 = ?");
			params.add(ab0494s00.getNombreDoc094());
		}
		if (ab0494s00 != null && ab0494s00.getOidDokusi094() != null) {
			where.append(" AND t1.OID_DOKUSI_094 = ?");
			params.add(ab0494s00.getOidDokusi094());
		}
		if (ab0494s00 != null && ab0494s00.getTipoDocumento() != null
				&& ab0494s00.getTipoDocumento().getIdTipoDoc091() != null) {
			where.append(" AND t1.ID_TIPO_DOC_094 = ?");
			params.add(ab0494s00.getTipoDocumento().getIdTipoDoc091());
		}
		if (ab0494s00 != null && ab0494s00.getDatosEnvioPostal() != null
				&& ab0494s00.getDatosEnvioPostal()
						.getIdDatosEnvioPostal069() != null) {
			where.append(" AND t1.ID_DATOS_ENVIO_POSTAL_094 = ?");
			params.add(
					ab0494s00.getDatosEnvioPostal().getIdDatosEnvioPostal069());
		}
		if (ab0494s00 != null && ab0494s00.getFormatoAport094() != null) {
			where.append(" AND t1.FORMATO_APORT_094 = ?");
			params.add(ab0494s00.getFormatoAport094());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0494s00 entity.
	 * 
	 *  ab0494s00            Ab0494s00 Bean with the criteria values to filter by.
	 *  startsWith            Boolean
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param ab0494s00 the ab 0494 s 00
	 * @param startsWith the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(DocumentoOS2 ab0494s00,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				DocumentoOS2DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0494s00 != null && ab0494s00.getIdDocumento094() != null) {
			where.append(" AND t1.ID_DOCUMENTO_094 = ?");
			params.add(ab0494s00.getIdDocumento094());
		}
		if (ab0494s00 != null && ab0494s00.getTareaOS2Continuar() != null
				&& ab0494s00.getTareaOS2Continuar().getIdTarea093() != null) {
			where.append(" AND t1.ID_TAREA_CONT_094 = ?");
			params.add(ab0494s00.getTareaOS2Continuar().getIdTarea093());
		}
		if (ab0494s00 != null && ab0494s00.getTramiteOS2() != null
				&& ab0494s00.getTramiteOS2().getIdTramite092() != null) {
			where.append(" AND t1.ID_TRAMITE_OS2_094 = ?");
			params.add(ab0494s00.getTramiteOS2().getIdTramite092());
		}
		if (ab0494s00 != null && ab0494s00.getOrigen094() != null) {
			where.append(" AND t1.ORIGEN_094 = ?");
			params.add(ab0494s00.getOrigen094());
		}
		if (ab0494s00 != null && ab0494s00.getFechaDoc094() != null) {
			where.append(" AND t1.FECHA_DOC_094 = ?");
			params.add(ab0494s00.getFechaDoc094());
		}
		if (ab0494s00 != null && ab0494s00.getRutaPif094() != null) {
			where.append(" AND UPPER(t1.RUTA_PIF_094) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0494s00.getRutaPif094().toUpperCase() + "%");
			} else {
				params.add("%" + ab0494s00.getRutaPif094().toUpperCase() + "%");
			}
			where.append(" AND t1.RUTA_PIF_094 IS NOT NULL");
		}
		if (ab0494s00 != null && ab0494s00.getNombreDoc094() != null) {
			where.append(" AND UPPER(t1.NOMBRE_DOC_094) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0494s00.getNombreDoc094().toUpperCase() + "%");
			} else {
				params.add(
						"%" + ab0494s00.getNombreDoc094().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_DOC_094 IS NOT NULL");
		}
		if (ab0494s00 != null && ab0494s00.getOidDokusi094() != null) {
			where.append(" AND UPPER(t1.OID_DOKUSI_094) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0494s00.getOidDokusi094().toUpperCase() + "%");
			} else {
				params.add(
						"%" + ab0494s00.getOidDokusi094().toUpperCase() + "%");
			}
			where.append(" AND t1.OID_DOKUSI_094 IS NOT NULL");
		}
		if (ab0494s00 != null && ab0494s00.getTipoDocumento() != null
				&& ab0494s00.getTipoDocumento().getIdTipoDoc091() != null) {
			where.append(" AND t1.ID_TIPO_DOC_094 = ?");
			params.add(ab0494s00.getTipoDocumento().getIdTipoDoc091());
		}
		if (ab0494s00 != null && ab0494s00.getDatosEnvioPostal() != null
				&& ab0494s00.getDatosEnvioPostal()
						.getIdDatosEnvioPostal069() != null) {
			where.append(" AND t1.ID_DATOS_ENVIO_POSTAL_094 = ?");
			params.add(
					ab0494s00.getDatosEnvioPostal().getIdDatosEnvioPostal069());
		}
		if (ab0494s00 != null && ab0494s00.getFormatoAport094() != null) {
			where.append(
					" AND UPPER(t1.FORMATO_APORT_094) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0494s00.getFormatoAport094().toUpperCase() + "%");
			} else {
				params.add("%" + ab0494s00.getFormatoAport094().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.FORMATO_APORT_094 IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Finds a list of rows in the SolicDocumentos table.
	 * 
	 *  solicdocumentos
	 *            SolicDocumentos
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<SolicDocumentos>
	 *
	 * @param solicdocumentos the solicdocumentos
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<DocumentoOS2> buscarPorIdTramiteYMetadatoNombre(
			DocumentoOS2 solicdocumentos, JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				DocumentoOS2DaoImpl.QUERY_SELECT);
		query.append(
				" WHERE t1.ID_TRAMITE_OS2_094 = ? AND UPPER(SUBSTR(t1.NOMBRE_DOC_094, 1, INSTR(t1.NOMBRE_DOC_094, '.', -1) - 1)) = ? ");
		// El metadato object_name nos devuelve el nombre del fichero en
		// minúsculas y sin extensión
		// Buscamos ese nombre en mayúsculas descartando lo que haya en BD a
		// partir del último punto

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<DocumentoOS2>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, solicdocumentos.getTramiteOS2().getIdTramite092(),
				solicdocumentos.getNombreDoc094().toUpperCase());
	}

	/**
	 * Finds a single row in the Ab0465s00 table.
	 * 
	 *  doc the doc
	 *  DocumentoAperturas
	 *
	 * @param doc the doc
	 * @return the documento OS 2
	 */
	@Transactional(readOnly = true)
	public DocumentoOS2 findByTramite(DocumentoOS2 doc) {
		StringBuilder query = new StringBuilder(
				DocumentoOS2DaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(doc);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		List<DocumentoOS2> docList = this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());

		return (DocumentoOS2) DataAccessUtils.uniqueResult(docList);
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

}
